package com.kuaike.scrm.common.service;

import com.kuaike.common.dto.resp.Node;

import com.kuaike.scrm.common.service.dto.req.OrgListReqDto;
import com.kuaike.scrm.common.service.dto.resp.DeptNameRespDto;
import com.kuaike.scrm.common.service.dto.resp.OrgListRespDto;
import com.kuaike.scrm.common.service.dto.resp.PositionRespDto;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author sunwen
 */
public interface OrgService {

    /**
     * 获取部门树形列表
     *
     * @param reqDto 请求参数对象
     * @return 部门树形列表
     */
    List<OrgListRespDto> treeList(OrgListReqDto reqDto);

    /**
     * 获取管理部门
     *
     * @param bizId             商户id
     * @param manageNodeIds     管理部门id集合
     * @return 管理部门集合
     */
    List<Node> getNodeWithoutChildren(Long bizId, Collection<Long> manageNodeIds);

    /**
     * 根据组织架构的id列表获取企微对应的部门id列表
     * @param nodeIds
     * @return
     */
    Set<Integer> getDepartmentIds(Set<Long> nodeIds);

    /**
     * 获取成员所有的职位
     *
     * @return 成员职位
     */
    PositionRespDto getPositions();

    /**
     * 根据部门id查询部门名字
     *
     * @param deptIds*/
    List<DeptNameRespDto> getDeptNames(List<Integer> deptIds);

    /**
     * 根据企业的部门ID，查询对应组织架构ID
     * 
     * @param corpId
     * @param deptId
     * @return
     */
    Long getNodeIdByDepartmentId(String corpId, Integer deptId);
}
