package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */
public enum SmsContentTypeEnum implements EnumService {
    CUSTOMER_DEFINE_SMS(1, "自定义短信"),
    SMS_TEMPLATE(2, "使用短信模板");

    private final int type;
    private final String desc;

    SmsContentTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SmsContentTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (SmsContentTypeEnum item : SmsContentTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SmsContentTypeEnum get(int type) {
        return CACHE.get(type);
    }

}
