package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ExportTaskType {
    CONTACT(1, "contactExport", "微信客户导出"),

    GLOBAL(2, "globalExport", "全局客户导出"),

    ORDER_EXPORT(3, "orderExport", "订单导出"),

    DEPT(4,"deptExport", "部门客户导出"),

    WECHAT_MSG(5, "wechatMsgExport", "企微聊天导出"),

    SPREAD_CODE(6, "spreadCodeExport", "推广码导出"),

    CUSTOMER_UPDATE(7,"customerUpdate","客户更新"),

    MARKETING_PLAN(8,"marketingPlanExport","渠道活码导出"),

    MARKETING_ADD_FRIEND(9,"marketingPlanAddFriendExport","渠道活码添加好友导出"),

    PAY_RECORD(10,"payRecordExport","回款单导出"),

    PAY_RECORD_REPORT(11,"payRecordReportExport","回款单报表导出"),

    TUITION_REPORT(12,"tuitionReportExport","学费报表导出");

    private final int value;
    private final String desc;
    private final String cNDesc;

    ExportTaskType(int value, String desc, String cNDesc) {
        this.value = value;
        this.desc = desc;
        this.cNDesc = cNDesc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    public String getCNDesc() {
        return cNDesc;
    }

    private static final Map<Integer, ExportTaskType> cache;

    static {
        cache = new HashMap<>();
        for (ExportTaskType item : ExportTaskType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ExportTaskType get(Integer value) {
        return cache.get(value);
    }
}
