/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums.sop;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum TaskRunStatusEnum {
    WAIT_EXECUTE(0, "\u5f85\u53d1\u9001"),
    EXECUTED(1, "\u5df2\u53d1\u9001"),
    SUCCESS(2, "\u53d1\u9001\u6210\u529f"),
    FAIL(3, "\u53d1\u9001\u5931\u8d25"),
    CREATED(4, "\u5df2\u521b\u5efa"),
    UNEXECUTE(5, "\u8d85\u65f6\u672a\u6267\u884c");

    private final String desc;
    private final int status;
    private static final Map<Integer, TaskRunStatusEnum> MAP;

    private TaskRunStatusEnum(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getDescByStatus(Integer status) {
        if (Objects.isNull(status)) {
            return null;
        }
        TaskRunStatusEnum taskRunStatusEnum = MAP.get(status);
        if (Objects.isNull((Object)taskRunStatusEnum)) {
            return null;
        }
        return taskRunStatusEnum.getDesc();
    }

    public String getDesc() {
        return this.desc;
    }

    public int getStatus() {
        return this.status;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(TaskRunStatusEnum.values()).collect(Collectors.toMap(TaskRunStatusEnum::getStatus, Function.identity())));
    }
}

