/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum TaskStatus {
    NORMAL(1, "\u542f\u7528"),
    BANED(0, "\u7981\u7528");

    private final Integer value;
    private final String desc;
    private static final Map<Integer, TaskStatus> MAP;

    public static TaskStatus getType(Integer type) {
        return MAP.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (TaskStatus type : TaskStatus.values()) {
            if (!desc.equals(type.getDesc())) continue;
            return type.getValue();
        }
        return null;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private TaskStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    static {
        MAP = Maps.newHashMap();
        for (TaskStatus type : TaskStatus.values()) {
            MAP.put(type.value, type);
        }
    }
}

