/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.model;

import lombok.Data;

import java.io.Serializable;

/**
 * 收到其他人向机器人发起的好友申请
 * 
 * @title ApplyFriendEvent
 * @author yanmaoyuan
 * @date 2020年11月13日
 * @version 1.0
 */
@Data
public class ApplyFriendEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    private String requestId;// 请求ID

    private String weworkId;// 企业微信ID

    private String contactId;// 企业微信ID

    private String nickname;// 昵称

    private String avatar;// 头像url

    private String corpId;// 企业ID

    private String corpName;// 企业名称

    private String unionId;// 

    private Integer sex;// 性别

    private Integer addType;// 加好友方式 1扫一扫 2手机号 3通过“某某”分享的名片

    private String addSource;

    private String applyContent;// 申请话术

    private Long applyUpdateTime;// 时间戳 (单位:秒)
}
