package com.kuaike.scrm.vip.dto.enums;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum WxError {

    UNKNOWN(0, ""),

    UN_VERIFIED(207, "为方便对方准确识别你，添加好友前请先完成实名认证")

//    Frequently_Msg(4,-2,"微信提示：操作过于频繁，可稍后再试"),
//
//    UserNotExist(4,-4,"搜索的用户不存在"),
//
//    Frequently1(4, -24, "微信提示：发送消息过于频繁，请稍后再试"),      // 发消息时提示：发送消息过于频繁，请稍后再试
//
//    Frequently2(4, -34, "微信提示：操作太频繁，请稍后再试。"),   // 邀请入群,建群太频繁时提示
//
//    Frequently2_bak(-34, 4, "微信提示：操作太频繁，请稍后再试。"),   // 邀请入群,建群太频繁时提示
//
//    ZombieFans(4,-44,"微信提示：对方不是你的好友"),       // 发消息时提示：xx开启了好友验证，你还不是他的好友
//
//    FileExceed(4, -3200, "文件发送超过今天发送限制"),
//
//    NotInChatroom(4, -21, "发送人已不在群里"),
//
//    RejectByPeer(4,-22,"消息已发出,但被对方拒收"),
//
//    NotFriend(4, -302, "非好友"),
//
//    NetworkNotAvailable(3, -1, "手机端网络不可用"),

    ;

    private final int errCode;

    private final String reason;

    WxError(int errCode, String reason) {
        this.errCode = errCode;
        this.reason = reason;
    }

    public int getErrCode() {
        return errCode;
    }

    public String getReason() {
        return reason;
    }

    private static final Map<String, WxError> MAP = Maps.newHashMap();

    static {
        MAP.putAll(Arrays.stream(WxError.values()).collect(Collectors.toMap(a -> StringUtils.join(new Integer[]{a.getErrCode()}, "##"), a -> a)));
    }

    public static String getReasonStr(int errCode) {
        String key = StringUtils.join(new Integer[]{errCode}, "##");
        WxError error = MAP.get(key);
        if (error == null) {
            return "";
        }
        return error.getReason();
    }
}
