package com.kuaike.scrm.common.enums.alloc;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 企微名片池生成状态
 * @author zhangbing
 *
 */
public enum AllocRuleStatus {


	NORMAL(0, "正常"),

	BACKUP(1, "启用备用备用资源"),

	NONE(2, "无资源");

	static final Map<Integer, AllocRuleStatus> MAP;

	static {
		MAP = Arrays.stream(values()).collect(Collectors.toMap(AllocRuleStatus::getStatus, Function.identity()));
	}

	private int status;

	private String label;

	private AllocRuleStatus(int status, String label) {
		this.status = status;
		this.label = label;
	}

	public int getStatus() {
		return status;
	}

	public String getLabel() {
		return label;
	}

	public static AllocRuleStatus get(int status) {
		return MAP.get(status);
	}
}
