package com.kuaike.scrm.vip.dto.message;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/11/16 20:50
 */
@Data
public class MessageSyncDto {
    private String weworkId;
    private List<WeworkMessage> messageList;
    private String corpId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkId), "weworkId not null");
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(messageList), "messageList not null");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId not null");
        messageList.forEach(t -> {
            t.setCorpId(corpId);
            t.setUpdateTime(new Date());
        }); //设置公司Id
    }
}
