package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 接替状态枚举类
 */
public enum TakeoverStatus implements EnumService{

    FAIL(0, "失败"),
    FINISH(1, "接替完毕"),
    WAIT_TAKEOVER(2, "接替中"),
    REFUSED(3, "客户拒绝"),
    OVER_LIMIT(4, "接替成员客户达到上限"),
    NO_RECORD(5, "无接替记录");

    private final int value;
    private final String desc;

    TakeoverStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, TakeoverStatus> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (TakeoverStatus item : TakeoverStatus.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static TakeoverStatus get(int status) {
        return CACHE.get(status);
    }
}
