/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */
public enum OrgTypeEnum implements EnumService {
    HEAD_OFFICE(1, "总部"),
    BRANCH_SCHOOL(2, "分校"),
    PROVINCE_OFFICE(3, "省级");

    private final int value;
    private final String desc;

    private OrgTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, OrgTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (OrgTypeEnum item : OrgTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static OrgTypeEnum get(int status) {
        return CACHE.get(status);
    }
}