/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ConditionOpEnum {
    OR(0, "or"),
    AND(1, "and"),
    NOT(2, "not");

    private Integer opType;
    private String desc;
    private static final Map<Integer, ConditionOpEnum> MAP;

    private ConditionOpEnum(Integer opType, String desc) {
        this.opType = opType;
        this.desc = desc;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ConditionOpEnum getByOp(Integer opType) {
        return MAP.get(opType);
    }

    static {
        MAP = Arrays.stream(ConditionOpEnum.values()).collect(Collectors.toMap(ConditionOpEnum::getOpType, Function.identity()));
    }
}

