package com.kuaike.scrm.vip.dto.kafka;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WeworkCommonMsg implements Serializable {

    private static final long serialVersionUID = -1851114292573115329L;

    /**
     * 发送系统
     *
     * @see WeworkSystemEnums
     */
    private String subSystem;

    /**
     * 时间
     */
    private long timestamp;

    /**
     * 消息类型
     *
     * @see WeworkCommonMsgType
     */
    private int msgType;

    /**
     * 标识, 可以用来表示唯一标识如:requestId, id等
     */
    private String key;

    /**
     * 消息体,通常为json
     */
    private String content;
}
