package com.kuaike.scrm.common.enums.sop;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2022/12/30
 * 执行状态 0 待发送 1 已发送 2 发送成功  3 发送失败
 **/
@Getter
public enum TaskRunStatusEnum {

    // 没到执行时间，还没有调用对应任务的创建接口
    WAIT_EXECUTE(0,"待发送"),

    EXECUTED(1,"已发送"),

    SUCCESS(2,"发送成功"),

    FAIL(3,"发送失败"),

    // 从 待发送->已创建 表示 调了对应任务接口创建了任务
    CREATED(4,"已创建"),

    // 过了执行时间当天24:00后，任务视为过期未执行
    UNEXECUTE(5, "超时未执行")
    ;

    private final String desc;
    private final int status;

    TaskRunStatusEnum(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    private static final Map<Integer, TaskRunStatusEnum> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(TaskRunStatusEnum.values()).collect(Collectors.toMap(TaskRunStatusEnum::getStatus, Function.identity())));
    }

    public static String getDescByStatus(Integer status) {
        if (Objects.isNull(status)) {
            return null;
        }
        TaskRunStatusEnum taskRunStatusEnum = MAP.get(status);
        if (Objects.isNull(taskRunStatusEnum)) {
            return null;
        }
        return taskRunStatusEnum.getDesc();
    }


}
