package com.kuaike.scrm.common.enums.sop;

import com.google.common.collect.ImmutableMap;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SopTaskType {
    GROUP_SEND(1, "企微群发"),

    CALL(2, "人工外呼"),

    SMS(3, "短信"),

    TEL_ADD_FRIEND(4, "批量加好友");

    private final int value;
    private final String desc;

    private static final Map<Integer, SopTaskType> MAP;

    static {
        MAP = ImmutableMap.copyOf(
                Arrays.stream(SopTaskType.values()).collect(Collectors.toMap(SopTaskType::getValue, Function.identity())));
    }

    SopTaskType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static SopTaskType getType(Integer value) {
        return MAP.get(value);
    }

    public static String getDescByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Optional.ofNullable(MAP.get(value)).map(SopTaskType::getDesc).orElse(null);

    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }
}
