package com.kuaike.scrm.common.enums.sop;

import java.util.HashMap;
import java.util.Map;

public enum SopRemindType {
    GROUP_SEND(1, "群发(官方)","管理员工给您下发了一条「企微群发」任务，请及时在企业微信客户端【群发助手】点击「发送」完成群发任务哦~\n"),
    YXB_SEND(2, "群发(营销宝)","您有一个「企业群发」任务，将通过「企微营销宝」自动群发，请保持企微营销宝在线哦~\n"),
    CALL(3, "人工外呼","您有一个「人工外呼」任务，请及时在「首页」——「工作台」——「外呼待办」完成外呼任务哦~\n"),
    TEL_ADD_FRIEND_OFFCIAL(4, "批量加好友(官方)","您有一个「批量加好友」任务，请及时在企业微信客户端，完成申请添加哦~\n"),
    TEL_ADD_FRIEND_YXB(5, "批量加好友(营销宝)","您有一个「批量加好友」任务，将通过「企微营销宝」自动完成申请，请保持企微营销宝在线哦~\n"),
    NO_TEMPLATE(6, "没有选择sop模板","您有一个营销sop任务，请查看「客户名单」，需要在今天完成联系客户任务哦~点击客户名单，可以查看客户昵称、手机号\n"),
    ;

    private final Integer value;
    private final String desc;
    private final String content;

    SopRemindType(Integer value, String desc,String content) {
        this.value = value;
        this.desc = desc;
        this.content = content;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public String getContent() {
        return content;
    }

    private static final Map<Integer, SopRemindType> CACHE;
    static {
        CACHE = new HashMap<>();
        for (SopRemindType item : SopRemindType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SopRemindType get(int value) {
        return CACHE.get(value);
    }
}
