package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


/**
 * @author sunwen
 * 系统默认角色类型
 */
public enum SystemRoleType implements EnumService {
    ADMIN(1, "系统管理员"),
    NORMAL(2, "普通用户");

    private final int value;
    private final String desc;

    SystemRoleType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SystemRoleType> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (SystemRoleType item : SystemRoleType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SystemRoleType get(int status) {
        return CACHE.get(status);
    }
}
