package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;


public enum OperateLogTypeEnum implements EnumService {
    LOGIN(1, "登录"),
    LOGOUT(2, "退出"),
    ADD(3, "添加"),
    EDIT(4, "修改"),
    DELETE(5, "删除"),
    EXPORT(6, "导出");


    private final int id;
    private final String name;

    OperateLogTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, OperateLogTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(2);
        for (OperateLogTypeEnum item : OperateLogTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static OperateLogTypeEnum get(int status) {
        return CACHE.get(status);
    }
}
