package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum GoodsSourceEnum  implements EnumService{
    ONLINE_SCHOOL(1,"百家云网校"),
    OTHER(2,"其他来源");

    private final int value;
    private final String desc;

    GoodsSourceEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, GoodsSourceEnum> cache;

    static {
        cache = new HashMap<>(2);
        for (GoodsSourceEnum item : GoodsSourceEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static GoodsSourceEnum get(int status) {
        return cache.get(status);
    }
}
