package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 审批模版类型
 */
public enum FlowTemplateTypeEnum implements EnumService {
    PRODUCT_ONLINE(1, "产品上线"),
    RECORD_SCORE(2, "录成绩"),
    REFUND(3, "退款"),
    FEEDBACK(4, "反馈"),
    DISCOUNT(5, "优惠申请"),
    ABANDON_CONTRACT_APPLY(6, "废除合同申请");

    private final int value;
    private final String desc;

    FlowTemplateTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, FlowTemplateTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (FlowTemplateTypeEnum e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static FlowTemplateTypeEnum get(int value) {
        return CACHE.get(value);
    }
}
