package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum DeptModMsgType implements EnumService{
    CREATE_DEPT(1,"新增部门"),
    DELETE_DEPT(2,"删除部门"),
    CREATE_USER(3,"新增成员"),
    UPDATE_USER(4,"更新成员"),
    DELETE_USER(5,"删除成员")
    ;

    private final int id;
    private final String name;

    DeptModMsgType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, DeptModMsgType> cache;

    static {
        cache = new HashMap<>();
        for (DeptModMsgType item : DeptModMsgType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static DeptModMsgType get(int status) {
        return cache.get(status);
    }

}
