package com.kuaike.scrm.common.enums;

public enum ConversationArchiveStatusEnum {

    UNKNOWN(0, "未知"),
    CONFIRM(1,  "待确认"),
    SIGNED(2,  "合同签订"),
    PAYBACK(3,  "已回款"),
    OPEN(4,  "已开通");

    private final int id;
    private final String name;

    ConversationArchiveStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static ConversationArchiveStatusEnum getEnumBy(int id) {
        switch (id) {
            case 1: return ConversationArchiveStatusEnum.CONFIRM;
            case 2: return ConversationArchiveStatusEnum.SIGNED;
            case 3: return ConversationArchiveStatusEnum.PAYBACK;
            case 4: return ConversationArchiveStatusEnum.OPEN;
            default:return ConversationArchiveStatusEnum.UNKNOWN;
        }
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
