package com.kuaike.scrm.common.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class MobileDto implements Serializable {
    private static final long serialVersionUID = 1L;

    private String mobile;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "手机号不能为空");
    }
}
