package com.kuaike.scrm.common.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class DelayItemDto implements Serializable {

    private String uniqueId;
    /**
     * 每次重试时间间隔（毫秒），不设置默认2000毫秒一次
     */
    private Long retryGapMillis;
    /**
     * 最大重试次数，不设置默认0次，不进行重试
     */
    private Integer maxRetryCount;
    /**
     * 已经重试的次数
     */
    private Integer retryCount;
    /**
     * 延迟对象类型
     * 1：算子结果requestId
     * 2：
     */
    private Integer type;
    /**
     * 载荷
     */
    private String content;
}
