package com.kuaike.scrm.common.enums.sop;

import java.util.HashMap;
import java.util.Map;

public enum SopContactType {
    WECHAT(1,"微信"),
    WEWORK(2,"企业微信"),
    CRM(3,"crm或其他")
    ;

    private final Integer value;
    private final String desc;

    SopContactType(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }


    private static final Map<Integer, SopContactType> CACHE;
    static {
        CACHE = new HashMap<>();
        for (SopContactType item : SopContactType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SopContactType get(int value) {
        return CACHE.get(value);
    }
}
