package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author louis
 * @date 2022/5/13
 */
public enum CallTaskFkTypeEnum implements EnumService {

    NO_ARRIVE_MEETING(1, "直播未到客通知");

    private final int id;
    private final String desc;

    CallTaskFkTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, CallTaskFkTypeEnum> cache;

    static {
        cache = new HashMap<>(3);
        for (CallTaskFkTypeEnum item : CallTaskFkTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static CallTaskFkTypeEnum get(int status) {
        return cache.get(status);
    }
}
