package com.kuaike.scrm.common.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: lwl
 * @date: 2022/9/16
 * @description: 添加好友状态 0：未添加 1：已添加 2：已流失
 **/
@Getter
public enum AddWeworkStatusEnum {
    NOT_ADD(0,"未添加"),
    ADD(1,"已添加"),
    DEL(2,"已流失")
    ;

    private Integer value;
    private String desc;
    AddWeworkStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, AddWeworkStatusEnum> cache;

    static {
        cache = new HashMap<>();
        for (AddWeworkStatusEnum item : AddWeworkStatusEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static AddWeworkStatusEnum get(int value) {
        return cache.get(value);
    }
}
