package com.kuaike.scrm.common.dto;

import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import lombok.Data;

import java.io.Serializable;

@Data
public class OperatorResultItemDtoV2 implements Serializable {

    /**
     * 结果集合客户数据类型
     * {@link OperatorResultCustomerType}
     */
    private Integer customerType;

    /**
     * 客户唯一标识，不能为空
     * 存储内容取决于 {@link com.kuaike.scrm.common.enums.OperatorResultCustomerType}
     */
    private String customerId;

    /**
     * 结果集合中成员数据类型
     * {@link OperatorResultMemberType}
     */
    private Integer memberType;

    /**
     * 成员唯一标识， 无需成员配对时，可以为空
     * 存储内容取决于 {@link com.kuaike.scrm.common.enums.OperatorResultMemberType}
     */
    private String memberId;
}
