package com.kuaike.scrm.common.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.OperatorResultCustomerType;
import com.kuaike.scrm.common.enums.OperatorResultMemberType;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Data
public class OperatorResult implements Serializable {

    private Long bizId;

    private String requestId;

    /**
     * 状态
     * 0：待执行
     * 1：执行中
     * 2：完成
     * 3：异常退出
     */
    private Integer status;

    /**
     * 结果集合客户数据类型
     * {@link OperatorResultCustomerType}
     */
    private Integer customerType;

    /**
     * 结果集合中成员数据类型
     * {@link OperatorResultMemberType}
     */
    private Integer memberType;

    /**
     * 结果集合,customer类型一致（记录最终类型统一后的结果）
     */
    private List<OperatorResultItemDto> list;

    /**
     * 结果集合,customer类型不一致（记录传参进来的混合参数，最后要转换成类型一致的并存储到list中）
     */
    private List<OperatorResultItemDtoV2> list2;

    /**
     * 失败原因记录
     */
    private String failReason;

    private Date createTime;
    /**
     * 保存最后一次操作时间，如：心跳，完成后，失败时更新时间
     */
    private Date updateTime;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "bizId can not be null or empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(requestId), "requestId can not be null or empty");
        Preconditions.checkArgument(Objects.nonNull(status), "status can not be null");
        Preconditions.checkArgument(Objects.nonNull(createTime), "createTime can not be null");

    }
}
