package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum OperatorResultMemberType implements IOperatorResultType {

    NOT_USE(0,"成员字段不使用"),

    WEWORK_USER_NUM(1,"成员字段存储weworkUserNum"),

    WEWORK_USER_ID(2,"成员字段存储weworkUserId"),

    DECRY_WEWORK_USER_ID(3, "成员解密后的weworkUserId"),

    WEWORK_DIGIT_ID(4,"成员字段存储weworkDigitId"),

    USER_ID(5,"成员字段存储userId")
    ;

    private Integer type;

    private String desc;

    OperatorResultMemberType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, OperatorResultMemberType> MAP;

    static {
        MAP = Arrays.stream(OperatorResultMemberType.values()).collect(Collectors.toMap(OperatorResultMemberType::getType, Function.identity()));
    }

    public static OperatorResultMemberType getByType(Integer type) {
        return MAP.get(type);
    }
}
