package com.kuaike.scrm.common.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/5/31 4:17 下午
 */
public enum JsMsgType {
    // 官方消息类型
    TEXT("text", "文本", true),

    IMAGE("image", "图片"),

    VIDEO("video", "视频"),

    FILE("file", "文件"),

    NEWS("news", "图文"),

    MINI_PROGRAM("miniprogram", "小程序"),
    // 业务消息类型
    MEETING("meeting", "会议", true),

    FRIEND_FISSION_WORDS("ffwords", "好友裂变", true),

    VOICE("voice", "语音"),

    NOTICE("notice", "群公告");

    private final String value;
    private final String desc;
    private final boolean isText;

    JsMsgType(String value, String desc) {
        this(value, desc, false);
    }

    JsMsgType(String value, String desc, boolean isText) {
        this.value = value;
        this.desc = desc;
        this.isText = isText;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isText() {
        return isText;
    }

    private static final Set<String> CACHE;

    private static final Map<String, JsMsgType> MAP;

    static {
        CACHE = Arrays.stream(JsMsgType.values()).map(a -> a.value).collect(Collectors.toSet());
        MAP = Arrays.stream(JsMsgType.values()).collect(Collectors.toMap(JsMsgType::getValue, Function.identity()));
    }

    public static boolean contains(String typeName) {
        if (StringUtils.isBlank(typeName)) {
            return false;
        }
        return CACHE.contains(typeName.toLowerCase(Locale.getDefault()));
    }

    public static JsMsgType get(String type) {
        return MAP.get(type.toLowerCase(Locale.getDefault()));
    }
}
