/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum GoodsOrderSource {
    WX_SHOP(1, "\u5fae\u4fe1\u5c0f\u5546\u5e97"),
    MEETING_COMMERCE(2, "\u76f4\u64ad\u5e26\u8d27\u5546\u54c1\u5b9a\u5355"),
    YOU_ZAN(3, "\u6709\u8d5e"),
    DOU_DIAN(4, "\u6296\u5e97"),
    TAO_BAO(5, "\u6dd8\u5b9d"),
    IMPORT(6, "\u624b\u5de5\u5f55\u5165"),
    NET_SCHOOL(7, "\u767e\u5bb6\u4e91\u6821");

    private static final Map<Integer, GoodsOrderSource> cache;
    private final int source;
    private final String desc;

    public static Collection<Integer> all() {
        return cache.keySet();
    }

    public int getSource() {
        return this.source;
    }

    public String getDesc() {
        return this.desc;
    }

    private GoodsOrderSource(int source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static boolean isFromSystem(Integer source) {
        return source == null || MEETING_COMMERCE.getSource() == source.intValue() || IMPORT.getSource() == source.intValue();
    }

    public static boolean isFromSystem(String source) {
        return StringUtils.isBlank((CharSequence)source) || Objects.equals(String.valueOf(MEETING_COMMERCE.getSource()), source) || Objects.equals(String.valueOf(IMPORT.getSource()), source);
    }

    static {
        cache = new HashMap<Integer, GoodsOrderSource>(2);
        for (GoodsOrderSource item : GoodsOrderSource.values()) {
            cache.put(item.getSource(), item);
        }
    }
}

