package com.kuaike.scrm.vip.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description: 群成员角色
 * @author: liuguohong
 * @create: 2020/11/09 15:42
 */

public enum ChatRoomMemberRole {
    COMMON((byte)0, "普通群成员"),
    MANAGER((byte)1, "群管理员"),
    OWNER((byte)2, "群主");

    Byte value;
    String desc;

    private static final Map<Byte, ChatRoomMemberRole> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(ChatRoomMemberRole::getValue, Function.identity()));
    }

    ChatRoomMemberRole(Byte value, String desc){
        this.value=value;
        this.desc=desc;
    }

    public static ChatRoomMemberRole memberRole(Byte value) {
        return MAP.get(value);
    }

    public Byte getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
