package com.kuaike.scrm.vip.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AndroidErrorCode {

    SUCCESS(0, "成功"),
    UNKNOWN_CMD(1, "未知指令"),
    PROCESS_TERMINAL(2, "手机进程被终止，导致任务失败"),
    INVOKE_EXCEPTION(3, "企业微信异常，请稍后再试"),//调用接口异常
    INPUT_EXCEPTION(4, "企业微信异常，请稍后再试~"),//后端输入参数异常
    DOWNLOAD_FAILED_MD5(5, "下载失败，请稍后再试"),//下载失败，MD5检验错误
    DOWNLOAD_FAILED(6, "网络异常，下载失败，请稍后再试"),                //其它原因，如网络
    UPLOAD_FAILED(7, "网络异常，上传失败，请稍后再试"),
    IPC_BIND_FAILED(8, "IPC服务绑定失败"),//---客户看不到
    IPC_INVOKE_EXCEPTION(9, "IPC调用异常"),//---客户看不到
    IPC_LOG_SEND_FAILED(10, "日志发送失败"),//---客户看不到
    SEND_TEXT_INPUT_NULL(11, "发送文本为空或没有发送对象"),
    SEND_IMG_INPUT_NULL(12, "发送图片为空或没有发送对象"),
    SEND_FILE_INPUT_NULL(13, "发送文件为空或没有发送对象"),
    SEND_VIDEO_INPUT_NULL(14, "发送视频为空或没有发送对象"),
    SEND_VOICE_INPUT_NULL(15, "发送语音为空或没有发送对象"),
    SEND_LINK_INPUT_NULL(16, "发送链接为空或没有发送对象"),
    SEND_PERSON_CARD_INPUT_NULL(17, "发送个人卡片为空或没有发送对象"),
    SEND_ROOM_CARD_INPUT_NULL(18, "发送群卡片为空或没有发送对象"),
    SEND_AT_TEXT_INPUT_NULL(19, "艾特成员不在群内或没有发送对象"),
    CREATE_CON_INPUT_NULL(20, "创建群聊会话的成员不能为空"),//创建会话参数为空
    ADD_MEMBER_INPUT_NULL(21, "被邀请入群成员不能为空"),//加人入群参数为空
    AT_USER_NULL(22, "@的对象不能为空"),
    REMOVE_MEMBER_INPUT_NULL(23, "移除群成员不能为空"),
    MODIFY_ROOM_NAME_INPUT_NULL(24, "群名称不能为空"),
    SEND_ROOM_NOTICE_INPUT_NULL(25, "发送群公告内容不能为空"),
    EXIT_ROOM_INPUT_NULL(26, "未找到需要退出的群聊会话"),
    SET_ROOM_NOTIFY_INPUT_NULL(27, "未找到需要设置免打扰的群聊会话"),
    SET_ROOM_OWNER_INPUT_NULL(28, "更改后的群主不能为空"),
    SET_INVITE_CONFIRM_INPUT_NULL(29, "未找到需要打开群聊邀请确认的群聊会话"),
    SET_ROOM_ADMIN_INPUT_NULL(30, "设置的群管理员不能为空"),
    SET_CONTACT_REMARK_INPUT_NULL(31, "备注不能为空"),
    ACCEPT_FRIEND_REQUEST_INPUT_NULL(32, "接受加好友请求参数为空"),//---客户看不到
    SEND_MSG_TYPE_ERROR(33, "仅支持发送消息给【外部群聊】【外部联系人】"),
    GET_CON_ERROR(34, "无法获取会话对象"),//---客户看不到
    GET_USER_ERROR(35, "无法获取用户对象"),//---客户看不到
    IS_NOT_EXTERNAL_ROOM(36, "非外部群，不支持"),

    IS_NOT_IN_ROOM(37, "成员已不在群内"),
    ROOM_NUMBER_LESS_THAN_FORTY(38, "群人数少于40"),//---客户看不到，小于40人直接调拉人入群的接口，大于等于40调群卡片接口
    IS_NOT_OUT_FRIEND(39, "非外部联系人，不支持"),
    IS_NOT_INTERNAL_FRIEND(40, "仅支持企业内部联系人"),
    UNKNOWN_EXCEPTION(41, "未知异常"),//---客户看不到
    CAN_NOT_REMOVE_YOURSELF(42, "不能从群中踢出自己"),
    OWNER_CAN_NOT_EXIT(43, "群主退群，需要先转让群主后才能退出"),
    EXTERNAL_CAN_NOT_BE_OWNER(44, "仅支持转让给企业内部联系人"),
    GENERATOR_QRCODE_NULL(45, "未找到需要生成群二维码的群聊会话"),
    GENERATOR_QRCODE_ERROR(46, "生成群二维码失败"),
    PARSE_QRCODE_FAILED(47, "生成群二维码失败"),//解析二维码失败
    IS_NOT_WECHAT_CON(48, "非外部联系人，不支持发消息"),
    CREATE_CON_NULL(49, "建群生成会话对象为空"),
    UPLOAD_LABEL_INPUT_NULL(50, "标签上传参数为空"),//---客户看不到
    IS_IN_ROOM(51, "联系人已经在群内了"),
    ADD_UNILATERAL_FRIEND_NULL(52, "添加单边好友请求参数为空"),
    TASK_EXPIRED(53, "任务过期"),
    CAN_NOT_AT_YOURSELF(54, "无法@自己"),
    PARSE_WX_URL_ERROR(55, "解析微信传递的Url失败"),
    WX_ROBOT_ID_ERROR(56, "微信机器人Id错误"),
    PARSE_URL_TO_USER_ERROR(57, "无法通过url获取用户对象"),
    ACCEPT_FRIEND_REQUEST_FROM_WX(58, "接收微信好友请求参数为空"),
    CONTACT_ID_NULL(59, "联系人Id为空"),
    IS_CONTACT_ALREADY(60, "已经是好友了"),
    CREATE_NUM_ERROR(61, "建群人数少于2人"),
    ADD_FRIEND_BY_PHONE_NULL(62, "搜索手机号加好友请求参数为空"),
    PHONE_NUM_ERROR(63, "手机号码错误"),
    SEARCH_FRIEND_NULL(64, "无法搜索到好友"),
    CREATE_EXTERNAL_ROOM_ERROR(65, "创建外部群必须要有一个外部联系人"),
    CONTACT_REMARK_ERROR(66, "备注和描述和原来的一样"),
    MSG_DB_ERROR(67, "数据库查询该消息错误"),
    INTERFACE_EXCEPTION(9999, "企微接口返回异常"),
    FAILED(10000, "失败");

    private final int value;

    private final String desc;

    AndroidErrorCode(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, AndroidErrorCode> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(AndroidErrorCode::getValue, Function.identity()));
    }

    public static AndroidErrorCode getByCode(int code) {
        return MAP.get(code);
    }
}
