package com.kuaike.scrm.common.enums;

import org.apache.commons.lang3.StringUtils;

public enum SettingEnum {

    UNKNOWN(0, "unknown", "未知"),
    MOBILE_ENCRYPT(1, "mobileEncrypt", "手机号中间4位加密"),
    RECOMMEND_SETTING(2, "wiseRecommendNumPerDay", "推送设置"),
    SHARE_CUSTOMER(3,"shareCustomer","客资共享"),
    REFUND_REASON(4,"refund_reason","退还原因"),
    APPROVAL_TYPE(5, "approval_type", "审批方式"),
    REFUND_WAY(10,"refundWay","退款方式"),
    ORDER_PAY_NOTIFY(11, "orderPayNotify", "订单支付通知"),
    TAG_SYNC(15, "tagSync", "标签同步"),

    MIN_DEL_FRIENDS_INTERVAL(20, "minDelFriendsInterval", "最小删除好友间隔"),
    MAX_DEL_FRIENDS_INTERVAL(21, "maxDelFriendsInterval", "最大删除好友间隔"),
    MIN_DEL_FRIENDS_LIMIT_COUNT(22, "minDelFriendsLimitCount", "最小删除好友数量，当好友数量低于该值时，不受每日删除上限限制"),
    EVERY_DAY_DEL_FRIENDS_UPPER_LIMIT(23, "everyDayDelFriendsUpperLimit", "每日删除好友上限")
    ;

    public static SettingEnum getEnum(String enumName) {
        if (StringUtils.isBlank(enumName)) {
            return SettingEnum.UNKNOWN;
        }
        for (SettingEnum value : SettingEnum.values()) {
            if (StringUtils.equals(enumName, value.getName())) {
                return value;
            }
        }
        return SettingEnum.UNKNOWN;
    }


    private int id;
    private String name;
    private String desc;

    SettingEnum(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }
}
