package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ParamEncryTypeEnum implements EnumService {
    MEETING_TYPE(1, "直播加密"),
    ORDER_TYPE(2, "订单详情加密"),
    MEETING_PAYBACK_TYPE(3, "直播回放加密");

    private final int id;
    private final String desc;

    private ParamEncryTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ParamEncryTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(3);
        for (ParamEncryTypeEnum item : ParamEncryTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ParamEncryTypeEnum get(int status) {
        return CACHE.get(status);
    }
}
