package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * author: jw
 * date: 2021/12/22 下午5:28
 * content:
 */
public enum DynamicFormType implements EnumService {
    EMPTY_FORM(1, "空白表单"),
    SURVEY_FORM(2, "问券调查表单"),
    ACTIVITY_FORM(3, "活动报名表单"),
    AFTER_SALE_FORM(4, "售后表单"),
    MARKETING_FORM(5, "营销落地页");

    DynamicFormType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private final int value;
    private final String desc;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DynamicFormType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (DynamicFormType e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static DynamicFormType get(int status) {
        return CACHE.get(status);
    }
}
