package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DelayHandleType {

    SOP_CAL_TASK_DETAIL_REQUEST_ID(1, "sopCalTaskDetail requestId回调处理")
    ;

    private Integer type;

    private String desc;

    DelayHandleType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, DelayHandleType> MAP;

    static {
        MAP = Arrays.stream(DelayHandleType.values()).collect(Collectors.toMap(DelayHandleType::getType, Function.identity()));
    }

    public static DelayHandleType getByType(Integer type) {
        return MAP.get(type);
    }
}
