package com.kuaike.scrm.common.dto;


import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 企微标签同步消息
 *
 * SCRM在收到企业微信回调时，要把当前客户的标签同步到其他成员的相同客户身上，并同步到CRM的leads_tag表中。
 *
 * @author yanmaoyuan
 * @date 2023/6/25
 */
@Data
public class WeworkTagMsg implements Serializable {
    private Long bizId;
    private String corpId;
    private String contactId;
    private Set<String> tagIds;

    private String weworkUserId;// 当前打标签的用户
    private Long userId;//
}

