/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.model;

import lombok.extern.slf4j.Slf4j;
import static com.kuaike.scrm.vip.dto.model.Constants.*;

/**
 * @title AbstractDispatcher
 * @author yanmaoyuan
 * @date 2020年11月12日
 * @version 1.0
 */
@Slf4j
@SuppressWarnings({"java:S1172","java:S1610"})
public abstract class AbstractDispatcher {

    /**
     * 消息派发入口
     * 
     * @param weworkMessage
     */
    public void dispatch(WeworkMessage weworkMessage) {
        Integer contentType = weworkMessage.getContentType();
        if (contentType == null) {
            log.warn("contentType is null, requestId={}", weworkMessage.getRequestId());
            return;
        }

        switch (contentType) {
            // 富文本消息，可能包含@人
            case CONTENT_TYPE_RICH_TEXT_0:
            case CONTENT_TYPE_RICH_TEXT_2: {
                text(weworkMessage);
                break;
            }
            // 图片
            case CONTENT_TYPE_IMAGE_7:
            case CONTENT_TYPE_IMAGE_14:
            case CONTENT_TYPE_IMAGE_101: {
                image(weworkMessage);
                break;
            }
            // 动画表情
            case CONTENT_TYPE_EMOTION_104: {
                emotion(weworkMessage);
                break;
            }
            // 语音
            case CONTENT_TYPE_VOICE_9:
            case CONTENT_TYPE_VOICE_16: {
                voice(weworkMessage);
                break;
            }
            // 视频
            case CONTENT_TYPE_VIDEO_5:
            case CONTENT_TYPE_VIDEO_17:
            case CONTENT_TYPE_VIDEO_23: {
                video(weworkMessage);
                break;
            }
            // 文件
            case CONTENT_TYPE_FILE_102: {
                file(weworkMessage);
                break;
            }
            // 链接卡片
            case CONTENT_TYPE_LINK_13: {
                link(weworkMessage);
                break;
            }
            // 个人名片
            case CONTENT_TYPE_PERSONAL_CARD_41: {
                personalCard(weworkMessage);
                break;
            }
            // 成员入群
            case CONTENT_TYPE_ADD_ROOM_MEMBER_1002: {
                addRoomMember(weworkMessage);
                break;
            }
            // 文本控件
            case CONTENT_TYPE_TEXT_CONTROL_1011: {
                textControl(weworkMessage);
                break;
            }
            default: {
                unknown(weworkMessage);
            }
        }
    }

    public boolean unknown(WeworkMessage weworkMessage) {
        log.info("Unknown contentType:{}, requestId:{}", weworkMessage.getContentType(), weworkMessage.getRequestId());
        return false;
    }

    public boolean text(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean image(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean emotion(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean voice(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean video(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean file(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean link(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean personalCard(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean addRoomMember(WeworkMessage weworkMessage) {
        return false;
    }

    public boolean textControl(WeworkMessage weworkMessage) {
        return false;
    }
}
