package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MeetingType implements EnumService{
    EXTERNAL_MEETING(1,"外部培训"),
    INTERNAL_MEETING(2,"内部直播");

    private final int value;
    private final String desc;

    MeetingType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (MeetingType item : MeetingType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static MeetingType get(int status) {
        return CACHE.get(status);
    }
}
