package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ExportTaskType {
    CONTACT(1, "contactExport", "微信客户导出"),

    GLOBAL(2, "globalExport", "全局客户导出"),

    ORDER_EXPORT(3, "orderExport", "订单导出"),

    DEPT(4,"deptExport", "部门客户导出"),

    WECHAT_MSG(5, "wechatMsgExport", "企微聊天导出"),

    SPREAD_CODE(6, "spreadCodeExport", "推广码导出"),

    WANG_SHANG_TRADE_REPORT(10, "wangShangTradeReportExport", "网商报表导出"),

    TRADE_ORDER(15, "tradeOrderExport", "商品订单订单"),
    DORM_ROOM(16, "dormRoomExport", "房间导出"),
    DORM_BED(17, "dormBedExport", "床铺导出"),
    DORM_STUDENT(18, "dormStudentExport", "住宿学员导出"),
    DORM_CHECKOUT_TASK(19, "dormCheckoutTaskExport", "退房任务导出"),
    DORM_CLEAN_TASK(20, "dormCleanTaskExport", "打扫任务导出"),
    DORM_MAINTAIN_TASK(21, "dormMaintainTaskExport", "维修任务导出");

    private final int value;
    private final String desc;
    private final String cNDesc;

    ExportTaskType(int value, String desc, String cNDesc) {
        this.value = value;
        this.desc = desc;
        this.cNDesc = cNDesc;
    }

    public int getValue() {
        return value;
    }


    public String getDesc() {
        return desc;
    }

    public String getCNDesc() {
        return cNDesc;
    }

    private static final Map<Integer, ExportTaskType> cache;

    static {
        cache = new HashMap<>();
        for (ExportTaskType item : ExportTaskType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ExportTaskType get(Integer value) {
        return cache.get(value);
    }
}
