package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 好友裂变 奖品剩余数量
 **/
public enum FriendFissionRestBonus implements EnumService{

    //剩余奖品数量一阶梯
    REST_BONUS_NUM_ONE(1,"${remainReward-1}"),
    //剩余奖品数量二阶梯
    REST_BONUS_NUM_TWO(2,"${remainReward-2}"),
    //剩余奖品数量三阶梯
    REST_BONUS_NUM_THREE(3,"${remainReward-3}");

    private final int value;
    private final String desc;

    FriendFissionRestBonus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, String> cache;

    static {
        cache = new HashMap<>(3);
        for (FriendFissionRestBonus item : FriendFissionRestBonus.values()) {
            cache.put(item.getValue(), item.getDesc());
        }
    }

    public static Map<Integer, String> getCache(){
        return cache;
    }

}
