/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.kafka.msg;

import com.google.common.base.Preconditions;
import com.kuaike.common.enums.SkyCommonMsgType;
import com.kuaike.common.enums.SystemEnum;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class SkCommonMessage
implements Serializable {
    private static final long serialVersionUID = -1851114292573115329L;
    String subSystem;
    long timestamp;
    int msgType;
    String key;
    String content;

    public void validate() {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.subSystem) && SystemEnum.contains(this.subSystem) ? 1 : 0) != 0, (Object)"subSystem is null or empty or not valid");
        Preconditions.checkArgument((boolean)SkyCommonMsgType.contains(this.msgType), (Object)"msgType is not valid");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"content is null or empty");
    }

    public static SkCommonMessageBuilder builder() {
        return new SkCommonMessageBuilder();
    }

    public String toString() {
        return "SkCommonMessage(subSystem=" + this.getSubSystem() + ", timestamp=" + this.getTimestamp() + ", msgType=" + this.getMsgType() + ", key=" + this.getKey() + ", content=" + this.getContent() + ")";
    }

    public void setSubSystem(String subSystem) {
        this.subSystem = subSystem;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSubSystem() {
        return this.subSystem;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String getKey() {
        return this.key;
    }

    public String getContent() {
        return this.content;
    }

    public SkCommonMessage() {
    }

    public SkCommonMessage(String subSystem, long timestamp, int msgType, String key, String content) {
        this.subSystem = subSystem;
        this.timestamp = timestamp;
        this.msgType = msgType;
        this.key = key;
        this.content = content;
    }

    public static class SkCommonMessageBuilder {
        private String subSystem;
        private long timestamp;
        private int msgType;
        private String key;
        private String content;

        SkCommonMessageBuilder() {
        }

        public SkCommonMessageBuilder subSystem(String subSystem) {
            this.subSystem = subSystem;
            return this;
        }

        public SkCommonMessageBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SkCommonMessageBuilder msgType(int msgType) {
            this.msgType = msgType;
            return this;
        }

        public SkCommonMessageBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SkCommonMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public SkCommonMessage build() {
            return new SkCommonMessage(this.subSystem, this.timestamp, this.msgType, this.key, this.content);
        }

        public String toString() {
            return "SkCommonMessage.SkCommonMessageBuilder(subSystem=" + this.subSystem + ", timestamp=" + this.timestamp + ", msgType=" + this.msgType + ", key=" + this.key + ", content=" + this.content + ")";
        }
    }
}

