/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.common.enums;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public enum MIMEType {
    JPG(1, "image/jpg", "jpg"),
    JPEG(2, "image/jpeg", "jpeg"),
    PNG(3, "image/png", "png"),
    MP3(4, "audio/mp3", "mp3"),
    AMR(5, "audio/amr", "amr"),
    SVG(6, "image/svg", "svg");

    public static Set<String> imgExtension;
    private static Map<String, MIMEType> extensionToTypeMap;
    private static Map<String, Integer> extensionToCodeMap;
    private static Map<Integer, String> codeToExtensionMap;
    private static Map<Integer, MIMEType> typeToExtensionMap;
    private int code;
    private String type;
    private String extension;

    private MIMEType(int code, String type, String extension) {
        this.code = code;
        this.type = type;
        this.extension = extension;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public String getExtension() {
        return this.extension;
    }

    public static MIMEType getType(String extension) {
        return extensionToTypeMap.get(extension);
    }

    public static Integer getCode(String extension) {
        return extensionToCodeMap.get(extension);
    }

    public static String getExtension(Integer code) {
        return codeToExtensionMap.get(code);
    }

    public static MIMEType getMimeType(Integer code) {
        return typeToExtensionMap.get(code);
    }

    static {
        imgExtension = Sets.newHashSet();
        extensionToTypeMap = Maps.newHashMap();
        extensionToCodeMap = Maps.newHashMap();
        codeToExtensionMap = Maps.newHashMap();
        typeToExtensionMap = Maps.newHashMap();
        for (MIMEType type : MIMEType.values()) {
            extensionToTypeMap.put(type.getExtension(), type);
            extensionToCodeMap.put(type.getExtension(), type.code);
            codeToExtensionMap.put(type.getCode(), type.getExtension());
            typeToExtensionMap.put(type.getCode(), type);
            if (!type.type.startsWith("image/")) continue;
            imgExtension.add(type.extension);
        }
    }
}

