
package com.kuaike.common.enums.order;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 退费状态
 * @title RefundStatus
 * @desc TODO 
 * @author zhangbing
 * @date 2018年7月25日
 * @version 1.0
 */
public enum RefundStatus {

    TUIKE(1, "退课"), ZHUANKE(2, "转课"), XYTF(3, "协议退费");
    
    private int status;
    private String label;
    
    private RefundStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    private static Map<Integer, RefundStatus> cache;
    
    static {
        cache = Maps.newHashMap();
        for (RefundStatus refundStatus : RefundStatus.values()) {
            cache.put(refundStatus.getStatus(), refundStatus);
        }
    }
    
    public int getStatus() {
    
        return status;
    }

    public void setStatus(int status) {
    
        this.status = status;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public static RefundStatus get(int status) {
        return cache.get(status);
    }
}

    
