package com.kuaike.common.enums;

/**
 * 删除状态
 * 
 * @author zhangbing
 *
 */
public enum DeleteStatus implements EnumService {

    NORMAL(0, "正常"), DELETED(1, "删除");

    private int status;
    private String label;

    private DeleteStatus(int status, String label) {
        this.status = status;
        this.label = label;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    /*
     * (non-Javadoc)
     * 
     * @see EnumService#getValue()
     */

    @Override
    public int getValue() {
        return status;
    }

    @Override
    public String getDesc() {
        return label;
    }
}
