package com.kuaike.common.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 模块权限注解
 * @author shanyu
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface ModulePremission {
  
  /**
   * 模块名
   * @return
   */
  String name() default "";
  
  /**
   * 模块编号
   * @return
   */
  int module();
  
  /**
   * 描述
   * @return
   */
  String desc() default "";

}
