/*
 * Decompiled with CFR 0.152.
 */
package com.wltea.analyzer.lucene;

import com.wltea.analyzer.IKSegmentation;
import com.wltea.analyzer.Lexeme;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class IKTokenizer
extends Tokenizer {
    private IKSegmentation _IKImplement;
    private CharTermAttribute termAtt;
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int finalOffset;

    public IKTokenizer(Reader in, boolean isMaxWordLength) {
        super(in);
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this._IKImplement = new IKSegmentation(in, isMaxWordLength);
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        Lexeme nextLexeme = this._IKImplement.next();
        if (nextLexeme != null) {
            this.termAtt.append(nextLexeme.getLexemeText());
            this.termAtt.setLength(nextLexeme.getLength());
            this.offsetAtt.setOffset(nextLexeme.getBeginPosition(), nextLexeme.getEndPosition());
            this.finalOffset = nextLexeme.getEndPosition();
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this._IKImplement.reset(this.input);
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }
}

