/*
 * Decompiled with CFR 0.152.
 */
package com.wltea.analyzer.lucene;

import com.wltea.analyzer.IKSegmentation;
import com.wltea.analyzer.Lexeme;
import com.wltea.analyzer.lucene.IKAnalyzer;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public final class IKQueryParser {
    private static ThreadLocal<Map<String, TokenBranch>> keywordCacheThreadLocal = new ThreadLocal();
    private static boolean isMaxWordLength = false;

    public static void setMaxWordLength(boolean isMaxWordLength) {
        IKQueryParser.isMaxWordLength = isMaxWordLength;
    }

    private static Query optimizeQueries(List<Query> queries) {
        if (queries.size() == 0) {
            return null;
        }
        if (queries.size() == 1) {
            return queries.get(0);
        }
        BooleanQuery mustQueries = new BooleanQuery();
        for (Query q : queries) {
            mustQueries.add(q, BooleanClause.Occur.MUST);
        }
        return mustQueries;
    }

    private static Map<String, TokenBranch> getTheadLocalCache() {
        Map<String, TokenBranch> keywordCache = keywordCacheThreadLocal.get();
        if (keywordCache == null) {
            keywordCache = new HashMap<String, TokenBranch>(4);
            keywordCacheThreadLocal.set(keywordCache);
        }
        return keywordCache;
    }

    private static TokenBranch getCachedTokenBranch(String query) {
        Map<String, TokenBranch> keywordCache = IKQueryParser.getTheadLocalCache();
        return keywordCache.get(query);
    }

    private static void cachedTokenBranch(String query, TokenBranch tb) {
        Map<String, TokenBranch> keywordCache = IKQueryParser.getTheadLocalCache();
        keywordCache.put(query, tb);
    }

    public static Query parse(String field, String query) {
        if (field == null) {
            throw new IllegalArgumentException("parameter \"field\" is null");
        }
        if (query == null || "".equals(query.trim())) {
            return new TermQuery(new Term(field));
        }
        TokenBranch root = IKQueryParser.getCachedTokenBranch(query);
        if (root != null) {
            return IKQueryParser.optimizeQueries(root.toQueries(field));
        }
        root = new TokenBranch(null);
        StringReader input = new StringReader(query.trim());
        IKSegmentation ikSeg = new IKSegmentation(input, isMaxWordLength);
        try {
            Lexeme lexeme = ikSeg.next();
            while (lexeme != null) {
                root.accept(lexeme);
                lexeme = ikSeg.next();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IKQueryParser.cachedTokenBranch(query, root);
        return IKQueryParser.optimizeQueries(root.toQueries(field));
    }

    public static Query parse(String ikQueryExp) {
        ExpressionParser ikExpParser = new ExpressionParser();
        return ikExpParser.parserExp(ikQueryExp);
    }

    public static Query parseMultiField(String[] fields, String query) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        for (String field : fields) {
            Query partQuery;
            if (field == null || (partQuery = IKQueryParser.parse(field, query)) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0) continue;
            resultQuery.add(partQuery, BooleanClause.Occur.SHOULD);
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String query, BooleanClause.Occur[] flags) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (flags == null) {
            throw new IllegalArgumentException("parameter \"flags\" is null");
        }
        if (flags.length != fields.length) {
            throw new IllegalArgumentException("flags.length != fields.length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            Query partQuery;
            if (fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], query)) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0) continue;
            resultQuery.add(partQuery, flags[i]);
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String[] queries) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (queries == null) {
            throw new IllegalArgumentException("parameter \"queries\" is null");
        }
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            Query partQuery;
            if (fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], queries[i])) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0) continue;
            resultQuery.add(partQuery, BooleanClause.Occur.SHOULD);
        }
        return resultQuery;
    }

    public static Query parseMultiField(String[] fields, String[] queries, BooleanClause.Occur[] flags) throws IOException {
        if (fields == null) {
            throw new IllegalArgumentException("parameter \"fields\" is null");
        }
        if (queries == null) {
            throw new IllegalArgumentException("parameter \"queries\" is null");
        }
        if (flags == null) {
            throw new IllegalArgumentException("parameter \"flags\" is null");
        }
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery resultQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            Query partQuery;
            if (fields[i] == null || (partQuery = IKQueryParser.parse(fields[i], queries[i])) == null || partQuery instanceof BooleanQuery && ((BooleanQuery)partQuery).getClauses().length <= 0) continue;
            resultQuery.add(partQuery, flags[i]);
        }
        return resultQuery;
    }

    public static void main(String[] args) {
        String ikQueryExp = "(id='ABcdRf' && date:{'20010101','20110101'} && keyword:'^\u9b54\u517d\u4e2d\u56fd$') || (content:'\u9b54\u517d \u4e2d\u56fd'  || ulr='www.ik.com') - name:'\u6797\u826f\u76ca'";
        Query result = IKQueryParser.parse(ikQueryExp);
        System.out.println(result);
    }

    static class ExpressionParser {
        private List<Element> elements = new ArrayList<Element>();
        private Stack<Query> querys = new Stack();
        private Stack<Element> operates = new Stack();

        public Query parserExp(String expression) {
            Query lucenceQuery;
            block4: {
                lucenceQuery = null;
                try {
                    this.splitElements(expression);
                    this.parseSyntax();
                    if (this.querys.size() == 1) {
                        lucenceQuery = this.querys.pop();
                        break block4;
                    }
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a \u7f3a\u5c11\u903b\u8f91\u64cd\u4f5c\u7b26 \u6216 \u62ec\u53f7\u7f3a\u5931");
                }
                finally {
                    this.elements.clear();
                    this.querys.clear();
                    this.operates.clear();
                }
            }
            return lucenceQuery;
        }

        private void splitElements(String expression) {
            if (expression == null) {
                return;
            }
            Element curretElement = null;
            char[] expChars = expression.toCharArray();
            block16: for (int i = 0; i < expChars.length; ++i) {
                switch (expChars[i]) {
                    case '&': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)38;
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        if (curretElement.type == '&') {
                            curretElement.append(expChars[i]);
                            this.elements.add(curretElement);
                            curretElement = null;
                            continue block16;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)38;
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    case '|': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)124;
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        if (curretElement.type == '|') {
                            curretElement.append(expChars[i]);
                            this.elements.add(curretElement);
                            curretElement = null;
                            continue block16;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)124;
                        curretElement.append(expChars[i]);
                        continue block16;
                    }
                    case '-': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)45;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case '(': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)40;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case ')': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)41;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case ':': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)58;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case '=': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)61;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case ' ': {
                        if (curretElement == null) continue block16;
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case '\'': {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)39;
                            continue block16;
                        }
                        if (curretElement.type == '\'') {
                            this.elements.add(curretElement);
                            curretElement = null;
                            continue block16;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)39;
                        continue block16;
                    }
                    case '[': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)91;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case ']': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)93;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case '{': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)123;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case '}': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)125;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    case ',': {
                        if (curretElement != null) {
                            if (curretElement.type == '\'') {
                                curretElement.append(expChars[i]);
                                continue block16;
                            }
                            this.elements.add(curretElement);
                        }
                        curretElement = new Element();
                        curretElement.type = (char)44;
                        curretElement.append(expChars[i]);
                        this.elements.add(curretElement);
                        curretElement = null;
                        continue block16;
                    }
                    default: {
                        if (curretElement == null) {
                            curretElement = new Element();
                            curretElement.type = (char)70;
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        if (curretElement.type == 'F') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        if (curretElement.type == '\'') {
                            curretElement.append(expChars[i]);
                            continue block16;
                        }
                        this.elements.add(curretElement);
                        curretElement = new Element();
                        curretElement.type = (char)70;
                        curretElement.append(expChars[i]);
                    }
                }
            }
            if (curretElement != null) {
                this.elements.add(curretElement);
                curretElement = null;
            }
        }

        private void parseSyntax() {
            for (int i = 0; i < this.elements.size(); ++i) {
                Query q;
                Element e = this.elements.get(i);
                if ('F' == e.type) {
                    Element e2 = this.elements.get(i + 1);
                    if ('=' != e2.type && ':' != e2.type) {
                        throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a = \u6216 \uff1a \u53f7\u4e22\u5931");
                    }
                    Element e3 = this.elements.get(i + 2);
                    if ('\'' == e3.type) {
                        i += 2;
                        if ('=' == e2.type) {
                            TermQuery tQuery = new TermQuery(new Term(e.toString(), e3.toString()));
                            this.querys.push((Query)tQuery);
                            continue;
                        }
                        if (':' != e2.type) continue;
                        String keyword = e3.toString();
                        if (keyword.startsWith("^") && keyword.endsWith("$")) {
                            Query pQuery = this.luceneQueryParse(e.toString(), keyword);
                            this.querys.push(pQuery);
                            continue;
                        }
                        Query tQuery = IKQueryParser.parse(e.toString(), e3.toString());
                        this.querys.push(tQuery);
                        continue;
                    }
                    if ('[' == e3.type || '{' == e3.type) {
                        i += 2;
                        LinkedList<Element> eQueue = new LinkedList<Element>();
                        eQueue.add(e3);
                        ++i;
                        while (i < this.elements.size()) {
                            Element eN = this.elements.get(i);
                            eQueue.add(eN);
                            if (']' == eN.type || '}' == eN.type) break;
                            ++i;
                        }
                        TermRangeQuery rangeQuery = this.toTermRangeQuery(e, eQueue);
                        this.querys.push((Query)rangeQuery);
                        continue;
                    }
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1a\u5339\u914d\u503c\u4e22\u5931");
                }
                if ('(' == e.type) {
                    this.operates.push(e);
                    continue;
                }
                if (')' == e.type) {
                    boolean doPop = true;
                    while (doPop && !this.operates.empty()) {
                        Element op = this.operates.pop();
                        if ('(' == op.type) {
                            doPop = false;
                            continue;
                        }
                        q = this.toQuery(op);
                        this.querys.push(q);
                    }
                    continue;
                }
                if (this.operates.isEmpty()) {
                    this.operates.push(e);
                    continue;
                }
                boolean doPeek = true;
                while (doPeek && !this.operates.isEmpty()) {
                    Element eleOnTop = this.operates.peek();
                    if ('(' == eleOnTop.type) {
                        doPeek = false;
                        this.operates.push(e);
                        continue;
                    }
                    if (this.compare(e, eleOnTop) == 1) {
                        this.operates.push(e);
                        doPeek = false;
                        continue;
                    }
                    if (this.compare(e, eleOnTop) == 0) {
                        q = this.toQuery(eleOnTop);
                        this.operates.pop();
                        this.querys.push(q);
                        continue;
                    }
                    q = this.toQuery(eleOnTop);
                    this.operates.pop();
                    this.querys.push(q);
                }
                if (!doPeek || !this.operates.empty()) continue;
                this.operates.push(e);
            }
            while (!this.operates.isEmpty()) {
                Element eleOnTop = this.operates.pop();
                Query q = this.toQuery(eleOnTop);
                this.querys.push(q);
            }
        }

        private Query toQuery(Element op) {
            if (this.querys.size() == 0) {
                return null;
            }
            BooleanQuery resultQuery = new BooleanQuery();
            if (this.querys.size() == 1) {
                return (Query)this.querys.get(0);
            }
            Query q2 = this.querys.pop();
            Query q1 = this.querys.pop();
            if ('&' == op.type) {
                BooleanClause[] clauses;
                if (q1 != null) {
                    if (q1 instanceof BooleanQuery) {
                        clauses = ((BooleanQuery)q1).getClauses();
                        if (clauses.length > 0 && clauses[0].getOccur() == BooleanClause.Occur.MUST) {
                            for (BooleanClause c : clauses) {
                                resultQuery.add(c);
                            }
                        } else {
                            resultQuery.add(q1, BooleanClause.Occur.MUST);
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.MUST);
                    }
                }
                if (q2 != null) {
                    if (q2 instanceof BooleanQuery) {
                        clauses = ((BooleanQuery)q2).getClauses();
                        if (clauses.length > 0 && clauses[0].getOccur() == BooleanClause.Occur.MUST) {
                            for (BooleanClause c : clauses) {
                                resultQuery.add(c);
                            }
                        } else {
                            resultQuery.add(q2, BooleanClause.Occur.MUST);
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.MUST);
                    }
                }
            } else if ('|' == op.type) {
                BooleanClause[] clauses;
                if (q1 != null) {
                    if (q1 instanceof BooleanQuery) {
                        clauses = ((BooleanQuery)q1).getClauses();
                        if (clauses.length > 0 && clauses[0].getOccur() == BooleanClause.Occur.SHOULD) {
                            for (BooleanClause c : clauses) {
                                resultQuery.add(c);
                            }
                        } else {
                            resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.SHOULD);
                    }
                }
                if (q2 != null) {
                    if (q2 instanceof BooleanQuery) {
                        clauses = ((BooleanQuery)q2).getClauses();
                        if (clauses.length > 0 && clauses[0].getOccur() == BooleanClause.Occur.SHOULD) {
                            for (BooleanClause c : clauses) {
                                resultQuery.add(c);
                            }
                        } else {
                            resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                        }
                    } else {
                        resultQuery.add(q2, BooleanClause.Occur.SHOULD);
                    }
                }
            } else if ('-' == op.type) {
                if (q1 == null || q2 == null) {
                    throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff1aSubQuery \u4e2a\u6570\u4e0d\u5339\u914d");
                }
                if (q1 instanceof BooleanQuery) {
                    BooleanClause[] clauses = ((BooleanQuery)q1).getClauses();
                    if (clauses.length > 0) {
                        for (BooleanClause c : clauses) {
                            resultQuery.add(c);
                        }
                    } else {
                        resultQuery.add(q1, BooleanClause.Occur.MUST);
                    }
                } else {
                    resultQuery.add(q1, BooleanClause.Occur.MUST);
                }
                resultQuery.add(q2, BooleanClause.Occur.MUST_NOT);
            }
            return resultQuery;
        }

        /*
         * Enabled aggressive block sorting
         */
        private TermRangeQuery toTermRangeQuery(Element fieldNameEle, LinkedList<Element> elements) {
            boolean includeFirst = false;
            boolean includeLast = false;
            String firstValue = null;
            String lastValue = null;
            Element first = elements.getFirst();
            if ('[' == first.type) {
                includeFirst = true;
            } else {
                if ('{' != first.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38");
                includeFirst = false;
            }
            Element last = elements.getLast();
            if (']' == last.type) {
                includeLast = true;
            } else {
                if ('}' != last.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u7f3a\u5c11\u7ed3\u675f\u62ec\u53f7");
                includeLast = false;
            }
            if (elements.size() < 4) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery \u9519\u8bef");
            if (elements.size() > 5) {
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery \u9519\u8bef");
            }
            Element e2 = elements.get(1);
            if ('\'' != e2.type) {
                if (',' != e2.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u683c\u5f0f\u9519\u8bef");
                firstValue = null;
                Element e3 = elements.get(2);
                if ('\'' != e3.type) throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff0cRangeQuery\u683c\u5f0f\u9519\u8bef");
                lastValue = e3.toString();
                return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
            }
            firstValue = e2.toString();
            Element e3 = elements.get(2);
            if (',' != e3.type) {
                throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38, RangeQuery\u7f3a\u5c11\u9017\u53f7\u5206\u9694");
            }
            Element e4 = elements.get(3);
            if ('\'' == e4.type) {
                lastValue = e4.toString();
                return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
            }
            if (e4 == last) return new TermRangeQuery(fieldNameEle.toString(), new BytesRef((CharSequence)firstValue), new BytesRef((CharSequence)lastValue), includeFirst, includeLast);
            throw new IllegalStateException("\u8868\u8fbe\u5f0f\u5f02\u5e38\uff0cRangeQuery\u683c\u5f0f\u9519\u8bef");
        }

        private Query luceneQueryParse(String fieldName, String keyword) {
            keyword = keyword.substring(1, keyword.length() - 1);
            String luceneExp = fieldName + ":\"" + keyword + "\"";
            QueryParser luceneQueryParser = new QueryParser(Version.LUCENE_4_9, "", (Analyzer)new IKAnalyzer());
            try {
                Query lucenceQuery = luceneQueryParser.parse(luceneExp);
                return lucenceQuery;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }

        private int compare(Element e1, Element e2) {
            if ('&' == e1.type) {
                if ('&' == e2.type) {
                    return 0;
                }
                return 1;
            }
            if ('|' == e1.type) {
                if ('&' == e2.type) {
                    return -1;
                }
                if ('|' == e2.type) {
                    return 0;
                }
                return 1;
            }
            if ('-' == e2.type) {
                return 0;
            }
            return -1;
        }

        private class Element {
            char type = '\u0000';
            StringBuffer eleTextBuff = new StringBuffer();

            public void append(char c) {
                this.eleTextBuff.append(c);
            }

            public String toString() {
                return this.eleTextBuff.toString();
            }
        }
    }

    private static class TokenBranch {
        private static final int REFUSED = -1;
        private static final int ACCEPTED = 0;
        private static final int TONEXT = 1;
        private int leftBorder;
        private int rightBorder;
        private Lexeme lexeme;
        private List<TokenBranch> acceptedBranchs;
        private TokenBranch nextBranch;

        TokenBranch(Lexeme lexeme) {
            if (lexeme != null) {
                this.lexeme = lexeme;
                this.leftBorder = lexeme.getBeginPosition();
                this.rightBorder = lexeme.getEndPosition();
            }
        }

        public int getLeftBorder() {
            return this.leftBorder;
        }

        public int getRightBorder() {
            return this.rightBorder;
        }

        public Lexeme getLexeme() {
            return this.lexeme;
        }

        public List<TokenBranch> getAcceptedBranchs() {
            return this.acceptedBranchs;
        }

        public TokenBranch getNextBranch() {
            return this.nextBranch;
        }

        public int hashCode() {
            if (this.lexeme == null) {
                return 0;
            }
            return this.lexeme.hashCode() * 37;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof TokenBranch) {
                TokenBranch other = (TokenBranch)o;
                if (this.lexeme == null || other.getLexeme() == null) {
                    return false;
                }
                return this.lexeme.equals(other.getLexeme());
            }
            return false;
        }

        boolean accept(Lexeme _lexeme) {
            int acceptType = this.checkAccept(_lexeme);
            switch (acceptType) {
                case -1: {
                    return false;
                }
                case 0: {
                    if (this.acceptedBranchs == null) {
                        this.acceptedBranchs = new ArrayList<TokenBranch>(2);
                        this.acceptedBranchs.add(new TokenBranch(_lexeme));
                    } else {
                        boolean acceptedByChild = false;
                        for (TokenBranch childBranch : this.acceptedBranchs) {
                            acceptedByChild = childBranch.accept(_lexeme) || acceptedByChild;
                        }
                        if (!acceptedByChild) {
                            this.acceptedBranchs.add(new TokenBranch(_lexeme));
                        }
                    }
                    if (_lexeme.getEndPosition() <= this.rightBorder) break;
                    this.rightBorder = _lexeme.getEndPosition();
                    break;
                }
                case 1: {
                    if (this.nextBranch == null) {
                        this.nextBranch = new TokenBranch(null);
                    }
                    this.nextBranch.accept(_lexeme);
                }
            }
            return true;
        }

        List<Query> toQueries(String fieldName) {
            ArrayList<Query> queries = new ArrayList<Query>(1);
            if (this.lexeme != null) {
                queries.add((Query)new TermQuery(new Term(fieldName, this.lexeme.getLexemeText())));
            }
            if (this.acceptedBranchs != null && this.acceptedBranchs.size() > 0) {
                if (this.acceptedBranchs.size() == 1) {
                    Query onlyOneQuery = IKQueryParser.optimizeQueries(this.acceptedBranchs.get(0).toQueries(fieldName));
                    if (onlyOneQuery != null) {
                        queries.add(onlyOneQuery);
                    }
                } else {
                    BooleanQuery orQuery = new BooleanQuery();
                    for (TokenBranch childBranch : this.acceptedBranchs) {
                        Query childQuery = IKQueryParser.optimizeQueries(childBranch.toQueries(fieldName));
                        if (childQuery == null) continue;
                        orQuery.add(childQuery, BooleanClause.Occur.SHOULD);
                    }
                    if (orQuery.getClauses().length > 0) {
                        queries.add((Query)orQuery);
                    }
                }
            }
            if (this.nextBranch != null) {
                queries.addAll(this.nextBranch.toQueries(fieldName));
            }
            return queries;
        }

        private int checkAccept(Lexeme _lexeme) {
            int acceptType = 0;
            if (_lexeme == null) {
                throw new IllegalArgumentException("parameter:lexeme is null");
            }
            acceptType = null == this.lexeme ? (this.rightBorder > 0 && _lexeme.getBeginPosition() >= this.rightBorder ? 1 : 0) : (_lexeme.getBeginPosition() < this.lexeme.getBeginPosition() ? -1 : (_lexeme.getBeginPosition() >= this.lexeme.getBeginPosition() && _lexeme.getBeginPosition() < this.lexeme.getEndPosition() ? -1 : (_lexeme.getBeginPosition() >= this.lexeme.getEndPosition() && _lexeme.getBeginPosition() < this.rightBorder ? 0 : 1)));
            return acceptType;
        }
    }
}

